/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.flash.net.FileReference;
import intrinsic.flash.net.FileReferenceList;

import org.eclipse.swt.SWT;

public class FileDialog extends Dialog {
	String [] filterNames = new String [0];
	String [] filterExtensions = new String [0];
	String [] fileNames = new String [0];
	String filterPath = "", fileName = "";
	int filterIndex = 0;

public FileDialog (Shell parent) {
	this (parent, SWT.PRIMARY_MODAL);
}

public FileDialog (Shell parent, int style) {
	super (parent, style);
	checkSubclass ();
}

public String getFileName () {
	return fileName;
}

public String[] getFileNames () {
	return fileNames;
}

public String[] getFilterExtensions () {
	return filterExtensions;
}

public int getFilterIndex () {
	return filterIndex;
}

public String[] getFilterNames () {
	return filterNames;
}

public String getFilterPath () {
	return filterPath;
}

public String open () {
	if ((style & SWT.MULTI) != 0) {
		new FileReferenceList().browse();
	} else {
		new FileReference().browse();
	}
	return null;
}

public void setFileName (String string) {
	fileName = string;
}

public void setFilterExtensions (String[] extensions) {
	filterExtensions = extensions;
}

public void setFilterIndex (int index) {
	filterIndex = index;
}

public void setFilterNames (String[] names) {
	filterNames = names;
}

public void setFilterPath (String string) {
	filterPath = string;
}

}
